% Processing ADV Pressure - Spectral Analysis
%--------------------------------------------------------------------------
%  
%  Uwe Best
%  Guyana Mangrove Data
% 
%%  Clearing variables

close all
clear

%%  Path of plotting codes

addpath('F:\Data_processing\Plotting codes\Plotting codes')
%addpath('D:\PHD\Data Collection Guyana\ADV Software\scripts and manual\scripts ADV\Plotting codes\despiking_tooblox\despiking_tooblox/')

%%   Filenames and folders of ADV data; Parameters for velocity signal check 

SNRmin  = 5;  % Minimum signal to noise ratio in dB
Corrmin = 70; % Minimum correlation
Path_figures= 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_5\Figures\';

for deployment= 1:1:6
    
    if deployment == 1  % Deployment which data is going to be analyzed
    
    fileName = {'TA00102';'TA00202'};
    Path1    = 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_test\';
    Folder   = {'12422\';'13933\'};
    elev_op =  [0.32 ; 0.13]; 
    
    elseif deployment == 2
    
    fileName = {'ADV_202';'ADV_102'};
    Path1    = 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_1\';
    Folder   = {'12422\';'13933\'};  
    elev_op =  [0.12 ; 0.06]; 

    elseif deployment == 3
    
    fileName = {'TB00202';'TB00202'};
    Path1    = 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_2\';
    Folder   = {'12422\';'13933\'};
    elev_op =  [0.12 ; 0.06]; % could not deploy

    elseif deployment == 4
    
    fileName = {'TA00302';'TB00302'};
    Path1    = 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_3\';
    Folder   = {'12422\';'13933\'};
    elev_op =  [0.06 ; 0.07]; 
    
    elseif deployment == 5
    
    fileName = {'TA00402';'TB00402'};
    Path1    = 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_4\';
    Folder   = {'12422\';'13933\'};
    elev_op =  [0.09 ; 0.09]; 
    else
    
    fileName = {'TA00502';'TB00502'};
    Path1    = 'F:\Figures_ADV\Fieldwork\Guyana_Data_processing\Chateau_Margot\ADV_Deployment_5\';
    Folder   = {'12422\';'13933\'};
    elev_op =  [0.07 ; 0.08]; 
    end
    
    for ADV = [1,2] % Instrument numbers
    %% Loading structure file of the ADV    
    
    folder    = Folder{ADV};
    file_name = fileName{ADV};
    Path      = strcat(Path1,folder);
    fullName  = strcat(Path,file_name,'.mat');
    load(fullName)
    
    elev= elev_op(ADV);
    
    %%  Velocity signal check (from Chanson et al., 2008) 
    
    % Choosing points with a high enough signal to noise ratio (SNR)
    
    S = find (ADVData.Data.SNRBeam1 >SNRmin & ...
        ADVData.Data.SNRBeam2>SNRmin & ...
        ADVData.Data.SNRBeam3 >SNRmin);
    
    % Choosing points with high enough correlation (%)
    
    C = find (ADVData.Data.CorrelationBeam1 >Corrmin & ...
        ADVData.Data.CorrelationBeam2>Corrmin & ...
        ADVData.Data.CorrelationBeam3 >Corrmin);
       
    % Points that meet all the previous criteria
    
    K = intersect(S,C); % Indexes of cases with good SNR and correlation
    
    % Removal of final part of the measurements (invalid measurements)
    
    if deployment == 1
        H = find(ADVData.Data.FullDate <'22-Nov-2019 14:00:00' & ADVData.Data.FullDate  > '23-Nov-2019 12:30:00'); 
        N = find(ADVData.Data.FullDate>='22-Nov-2019 14:00:00' & ADVData.Data.FullDate  <= '23-Nov-2019 12:30:00');
    
    elseif deployment == 2
        H = find(ADVData.Data.FullDate <'24-Nov-2019 17:30:00' & ADVData.Data.FullDate  > '29-Nov-2019 14:00:00'); 
        N = find(ADVData.Data.FullDate>='24-Nov-2019 17:30:00' & ADVData.Data.FullDate  <= '29-Nov-2019 14:00:00');
    
    elseif deployment == 3
        H = find(ADVData.Data.FullDate <'03-Dec-2019 20:00:00' & ADVData.Data.FullDate  > '09-Dec-2019 13:00:00'); 
        N = find(ADVData.Data.FullDate>='03-Dec-2019 20:00:00' & ADVData.Data.FullDate  <= '09-Dec-2019 13:00:00');
    
    elseif deployment == 4
        H = find(ADVData.Data.FullDate <'13-Dec-2019 10:00:00' & ADVData.Data.FullDate  > '17-Dec-2019 07:00:00'); 
        N = find(ADVData.Data.FullDate>='13-Dec-2019 10:00:00' & ADVData.Data.FullDate  <= '17-Dec-2019 07:00:00');    
    
    elseif deployment == 5
        H = find(ADVData.Data.FullDate <'20-Dec-2019 16:00:00' & ADVData.Data.FullDate  > '28-Dec-2019 16:40:00'); 
        N = find(ADVData.Data.FullDate>='20-Dec-2019 16:00:00' & ADVData.Data.FullDate  <= '28-Dec-2019 16:40:00');  
    
    else
        H = find(ADVData.Data.FullDate <'06-Jan-2020 14:30:00' & ADVData.Data.FullDate  > '11-Jan-2020 10:20:00'); 
        N = find(ADVData.Data.FullDate>='06-Jan-2020 14:30:00' & ADVData.Data.FullDate  <= '11-Jan-2020 10:20:00');
    end
    
    % Points that do not meet these criteria
    
    AllIndex = find(ADVData.Data.BurstCounter); % All indexes
    SC = setdiff(N,K); % Finding indexes which are not valid 
    K = setdiff(K,H); % Taking out H points, which are directly non-usable 
       
    % Plot of points with low correlation
    
    figure, holdGridBox
    plot(ADVData.Data.FullDate(N),ADVData.Data.Pressure(N),'kx')
    plot(ADVData.Data.FullDate(SC),ADVData.Data.Pressure(SC),'rx')
    ylabel('mH20 [m]')
    legend ('All','Points of low correlation/SNR')
    
    savefig(gcf, [Path1,'Points of low correlation' '_' num2str(ADV) '.fig'], 'compact')
    saveas(gcf,  [Path1,'Points of low correlation' '_' num2str(ADV) '.png'])
    close;
    
     %% Selection valid part of dataset
    
    P = ADVData.Data.Pressure;
    t = ADVData.Data.FullDate;
   
    time = datenum(ADVData.Data.FullDate);
    time = time-time(1);
    date = ADVData.Data.FullDate;
    
    
    p_tide = movmean(P,6001,'omitnan'); % moving mean to filter out waves and look at tide+surge, why 6001-sample 20mins
    p_wave=P-p_tide; %Dynamic Pressure portion


    figure1 = figure;
    figure1.WindowState = 'maximized'

    axes1 = axes('Parent',figure1);
    hold(axes1,'on');

    plot(t, P);  
    hold on;
    plot(t, p_tide);
    hold on;
    plot(t, p_wave);

    xlabel('Time (MM DD HH MM SS)','FontWeight','bold','FontAngle','italic')
    ylabel('Pressure (mH20)','FontWeight','bold','FontAngle','italic')
    title('Overview of the Pressure Data');
    legend1= legend('Total Pressure', 'Hydrostatic Pressure', 'Dynamic Pressure');
    set(legend1,'Location','best');
    box(axes1,'on');
    set(axes1,'FontAngle','italic','FontSize',20,'FontWeight','bold','XGrid',...
        'on','YGrid','on');

    savefig(gcf, [Path1,'Guyana' '_' num2str(ADV) '.fig'], 'compact')
    saveas(gcf,  [Path1,'Guyana' '_' num2str(ADV) '.png'])
    close;
    
    %% Spectral Analysis
    p=P;
    fs=4;
    
    nt   = length(p);    % total duration of the pressure signals
    du   = 1200;          % duration of the intervals where wave parameters are calculated (s) (30 mins =1800s)
    dt   = 1/fs;          % time interval between pressure measurements (s)
    nh   = round(du/dt);  % number of measurements in a du (s) long interval
    np   = floor(nt/nh);  % total number of measurements in the pressure signals
    
    nsample = 2^7*fs;    % 
    df = 1/nsample/dt;
    
    for jp =1:1:np
     
    np-jp;             % remaining intervals for analysis
    tm(jp)=jp;  
    % Edit this to plot a select number of bursts
    
    %% Selecting pressure data of interval jp
    Pt1       = p(1+(jp-1)*nh:jp*nh); % selecting pressure
    t_burst   = t(1+(jp-1)*nh:jp*nh); %selecting time
    
    Pm1(jp)   = mean(Pt1);                           % mean pressure (mH20)- Separation of the Hydrostatic Pressure
    Pss1      = detrend(Pt1);                        % wave pressure (mH20)- Separation of the Dynamic Pressure
    h1(jp)    = elev+ Pm1(jp);                       % depth (mH20)
    var_p(jp,1) = var(Pss1(:));
    %% Variance Density Spectrum
     
     pp=p(1+(jp-1)*nh:jp*nh);
     tt=t(1+(jp-1)*nh:jp*nh);
     tt_new=datenum(tt);
     
   % if var_p(jp,1)>=0.00001;
     
     %Producing the Variance Density Plot per burst
    % [f,v]= spectrumsimple(tt(:), pp(:),'detrend',1);
     
     [Ps1,F1]  = jspect(Pss1,Pss1,nsample,dt,1,1,1);
     figureP = figure;
     figureP.WindowState = 'maximized';
    
     axesP = axes('Parent',figureP);
     hold(axesP,'on');
     hold on
     semilogx(F1,Ps1,'LineWidth',2);
     drawnow;
     title('Energy Density per Burst ');
     xlabel('Frequency (Hz)');
     ylabel('Energy Density (m^2. s)');
     box(axesP,'on');
     set(axesP,'FontSize',20,'XGrid','on','XMinorTick','on','XScale','log',...
     'YGrid','on');
 
     savefig(gcf, [Path_figures,'Pressure_Density' '_' num2str(ADV) '_' num2str(deployment) '_' num2str(jp) '.fig'], 'compact')
     saveas(gcf,  [Path_figures,'Pressure_Density' '_' num2str(ADV) '_' num2str(deployment) '_' num2str(jp) '.png'])
     close(gcf);
     %%
     
     if jp == 1
       k1 = zeros(length(F1),1);
       
       for kk = 1:length(k1)
               k1(kk) = wavenumber(1/F1(kk),h1(jp)); % wave number
       end
       
     %% Converting from pressure spectrum to surface elevation spectrum
       
       trans1    = (cosh(k1.*(h1(jp)))./(cosh(k1.*elev))).^2; 
       trans1    = min(trans1,3);
       
     %% Selecting high frequencies and low frequencies  ---Maybe alter this
       
       %ilow1     = find(F1>0 & F1<=0.05);
       %ihigh1    = find(F1>0.05);
       
       ilow1     = find(F1>0.04 & F1<=1);  % Short Wave (1-25 sces)
       ihigh1    = find(F1>0.04);   % Long Wave (f>25 sces)
    
    end
    
  % if var_p(jp,1)>=0.001;
    
        Es1(:,jp,1)      = Ps1(:,1).*trans1;                  % surface elevation spectrum
        m0(jp,1)         = sum(Es1(:,jp,1))*df;               % m0
        %Etot(jp,1)       = rho*g*(sum(Es1(:,jp,1))*df);
        Hm01(jp,1)       = 4*sqrt(sum(Es1(:,jp,1))*df);       % significant wave height
        Hmax(jp,1)       =max(Hm01);
        Hm0_hi1(jp,1)    = 4*sqrt(sum(Es1(ihigh1,jp,1))*df);  % significant wave height, of high frequency range
        Hm0_lo1(jp,1)    = 4*sqrt(sum(Es1(ilow1,jp,1))*df);   % significant wave height, of low frequency range
        Tm01(jp,1)       = (sum(Es1(:,jp,1))*df)/(sum(F1.*Es1(:,jp,1)*df)); % mean period
        
      
%         figureE = figure;
%         figureE.WindowState = 'maximized';
% 
%         axesE = axes('Parent',figureE);
%         hold(axesE,'on');
%         hold on
%         semilogx(F1,Es1,'LineWidth',2);
%         drawnow;
%         title('Energy Density per Burst ');
%         xlabel('Frequency (Hz)');
%         ylabel('Energy Density (m^2. s)');
%         box(axesE,'on');
%         set(axesE,'FontSize',20,'XGrid','on','XMinorTick','on','XScale','log',...
%          'YGrid','on');
% 
%         savefig(gcf, [Path_figures,'Energy_Density' '_' num2str(ADV) '_' num2str(deployment) '_' num2str(jp) '.fig'], 'compact')
%         saveas(gcf,  [Path_figures,'Energy_Density' '_' num2str(ADV) '_' num2str(deployment) '_' num2str(jp) '.png'])
%         close(gcf);
  
%     else
%         fprintf('Spectral Calculation will not be computed  \n')
    end
 %% Plotting wave properties

%[Tm02 spikes]=spikeRemoval(Tm01);

figure_spec=figure('Color',[1 1 1]);
figure_spec.WindowState = 'maximized';
axes_spec = axes('Parent',figure_spec);

paperDims(1.2,1), holdGridBox

subplot1 = subplot(4,1,1,'Parent',figure_spec);
hold(subplot1,'on');
plot(Hm01,'Parent',subplot1,'MarkerSize',8,'LineWidth',2,'Color',[0 0 0]);
ylabel('H_{s}  [m]','VerticalAlignment','bottom','FontName','calibri');
%xlim(subplot1,[0 200]);
box(subplot1,'on');
set(subplot1,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

% Create subplot
subplot2 = subplot(4,1,2,'Parent',figure_spec);
hold(subplot2,'on');
plot(Tm01,'Parent',subplot2,'MarkerSize',8,'LineWidth',2,'Color',[1 0 0]);
ylabel('T_{m}  [s]','VerticalAlignment','bottom','FontName','calibri');
%xlim(subplot2,[0 200]);
box(subplot2,'on');
set(subplot2,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

% Create subplot
subplot3 = subplot(4,1,3,'Parent',figure_spec);
hold(subplot3,'on');
plot(h1,'Parent',subplot3,'MarkerSize',8,'LineWidth',2,'Color',[0 0 1]);
ylabel('Depth [m]','VerticalAlignment','bottom','FontName','calibri');
xlabel('Burst No. (-)','VerticalAlignment','cap','FontName','calibri');
box(subplot3,'on');
%xlim(subplot3,[0 200]);
box(subplot3,'on');
set(subplot3,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

ratio=Hm01/h1;

% Create subplot
subplot3 = subplot(4,1,4,'Parent',figure_spec);
hold(subplot4,'on');
plot(ratio,'Parent',subplot4,'MarkerSize',8,'LineWidth',2,'Color',[0 0 1]);
ylabel('Depth [m]','VerticalAlignment','bottom','FontName','calibri');
xlabel('Burst No. (-)','VerticalAlignment','cap','FontName','calibri');
box(subplot4,'on');
%xlim(subplot3,[0 200]);
box(subplot4,'on');
set(subplot4,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

%datetick('x', 'MM')

savefig(gcf, [Path_figures,'Spectral Analysis' '_' num2str(ADV) '_' num2str(deployment) '_' num2str(jp) '.fig'], 'compact')
saveas(gcf,  [Path_figures,'Spectral Analysis' '_' num2str(ADV) '_' num2str(deployment) '_' num2str(jp) '.png'])
   
%% Saving variables
Results.Es1=  Es1;
Results.m0= m0;
Results.Hm0 = Hm01;
Results.Hm0hi1 = Hm0_hi1;
Results.Hm0lo1 = Hm0_lo1;
Results.Tm0 = Tm01;
Results.Depth = h1;
Results.pressure = P;
Results.time = t;
Results.var=var_p; %Check for good bursts
% Results.IG=up; %IG
% Results.SW=up2;

fullname=strcat(strcat(Path1,'WaveParameters_ADV_' , num2str(ADV) , num2str(deployment) , '.mat'));
save(fullname,'Results')

end

end
